from __future__ import generators
import plus
import Arenas
import random
import Hazards
import math
import DSLHaz

class BoxArena(Arenas.SuperArena):
    "On two levels, use the lift to get up and down, red = down, green = up, and don't get off while it's moving or you'll end up in orbit."
    name = "DSL Space Station Arena"
    preview = "DSLSpaceArena/DSLSpaceArena_preview.bmp"
    game_types = ['OBSTACLE COURSE']
    extent = (-30, 30, 30, -30)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/DSLSpaceArena/DSLSpaceArena.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)
        
        degrad = 0.01745
        self.AddStaticCamera("Pad 1 Cam", (-25, 55, 25), (83*degrad,135*degrad),59*degrad)
        self.AddStaticCamera("Pad 2 Cam", (25, 55, -25), (83*degrad,-45*degrad),59*degrad)
        self.AddStaticCamera("Pad 3 Cam", (-25, 55, -25), (83*degrad,45*degrad),59*degrad)
        self.AddStaticCamera("Pad 4 Cam", (25, 55, 25), (83*degrad,225*degrad),59*degrad)
	self.AddWatchCamera("Watch Cam 1", (0, 18, 6), (6, 18, 30*degrad, 10*degrad))
	self.AddWatchCamera("Watch Cam 2", (0, 20, 9), (6, 20, 30*degrad, 20*degrad))
	self.AddWatchCamera("Watch Cam 3", (0, 22, 12), (6, 22, 30*degrad, 30*degrad))
	self.AddWatchCamera("Watch Cam 4", (0, 24, 15), (6, 24, 30*degrad, 40*degrad))
	
        self.players = ()

        
        
    def AddShadowReceivers(self):
        self.SetShadowSource(5.897, 19.159, 5.899)
        
        # Main Arena Floor Shadow Triangles
        self.AddShadowTriangle((-10.2877,0.676244,1.83754), (-12.4182,0.676244,12.4283), (-12.4182,0.676244,1.83754))
        self.AddShadowTriangle((-8.17686,0.676244,9.91855), (-8.17686,0.676244,12.4283), (-12.4182,0.676244,12.4283))
        self.AddShadowTriangle((-8.17686,0.676244,9.91855), (-12.4182,0.676244,12.4283), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((2.25999,0.676244,12.4283), (-2.49123,0.676244,12.4283), (-2.49123,0.676244,9.91855))
        self.AddShadowTriangle((2.25999,0.676244,9.91855), (2.25999,0.676244,12.4283), (-2.49123,0.676244,9.91855))
        self.AddShadowTriangle((12.413,0.676244,12.4283), (7.93297,0.676244,12.4283), (7.93297,0.676244,9.91855))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (12.413,0.676244,12.4283), (7.93297,0.676244,9.91855))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (12.413,0.676244,1.91641), (12.413,0.676244,12.4283))
        self.AddShadowTriangle((8.17711,0.676244,-9.92447), (12.413,0.676244,-12.4279), (10.2878,0.676244,-1.93329))
        self.AddShadowTriangle((10.2878,0.676244,-1.93329), (12.413,0.676244,-12.4279), (12.413,0.676244,-1.93329))
        self.AddShadowTriangle((8.17711,0.676244,-9.92447), (8.17711,0.676244,-12.4279), (12.413,0.676244,-12.4279))
        self.AddShadowTriangle((-2.26871,0.676244,-12.4279), (2.49519,0.676244,-12.4279), (2.49519,0.676244,-9.92447))
        self.AddShadowTriangle((-2.26871,0.676244,-9.92447), (-2.26871,0.676244,-12.4279), (2.49519,0.676244,-9.92447))
        self.AddShadowTriangle((-12.4182,0.676244,-12.4279), (-7.93688,0.676244,-12.4279), (-7.93688,0.676244,-9.92447))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (-12.4182,0.676244,-12.4279), (-7.93688,0.676244,-9.92447))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (-12.4182,0.676244,-1.8361), (-12.4182,0.676244,-12.4279))
        self.AddShadowTriangle((-2.49123,0.676244,9.91855), (-8.17686,0.676244,9.91855), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((2.49519,0.676244,-9.92447), (8.17711,0.676244,-9.92447), (10.2878,0.676244,-1.93329))
        self.AddShadowTriangle((10.2878,0.676244,-1.93329), (-10.2877,0.676244,-1.8361), (-2.26871,0.676244,-9.92447))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (7.93297,0.676244,9.91855), (2.25999,0.676244,9.91855))
        self.AddShadowTriangle((2.25999,0.676244,9.91855), (-2.49123,0.676244,9.91855), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (2.25999,0.676244,9.91855), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((10.2878,0.676244,-1.93329), (10.2878,0.676244,1.91641), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (10.2878,0.676244,-1.93329), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((-2.26871,0.676244,-9.92447), (2.49519,0.676244,-9.92447), (10.2878,0.676244,-1.93329))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (-7.93688,0.676244,-9.92447), (-2.26871,0.676244,-9.92447))
        
        # Hazard Shadow Triangles
        self.AddShadowTriangle((-8.0217,0.407085,-12.2193), (-2.21868,0.407085,-12.2193), (-2.21868,0.407085,-9.90302))
        self.AddShadowTriangle((-2.21868,0.407085,-9.90302), (-8.0217,0.407085,-9.90302), (-8.0217,0.407085,-12.2193))
        self.AddShadowTriangle((2.42165,0.407085,-12.2193), (8.22466,0.407085,-12.2193), (8.22466,0.407085,-9.90302))
        self.AddShadowTriangle((8.22466,0.407085,-9.90302), (2.42165,0.407085,-9.90302), (2.42165,0.407085,-12.2193))
        self.AddShadowTriangle((-8.24321,0.407085,9.84521), (-2.4402,0.407085,9.84521), (-2.4402,0.407085,12.1615))
        self.AddShadowTriangle((-2.4402,0.407085,12.1615), (-8.24321,0.407085,12.1615), (-8.24321,0.407085,9.84521))
        self.AddShadowTriangle((2.20013,0.407085,9.84521), (8.00315,0.407085,9.84521), (8.00315,0.407085,12.1615))
        self.AddShadowTriangle((8.00315,0.407085,12.1615), (2.20013,0.407085,12.1615), (2.20013,0.407085,9.84521))
        
    def HazardsOn(self, on):
	self.lstatus = 0
	self.ltimer = 0
	self.called = 0
        prism = self.AddPrismatic("arena_collision", "botlift_collision", 0, 0, -13, 7.0, -8.0, 0)
        self.lift1 = DSLHaz.Lift(prism, (0.0, 0.0, -8))
        # self.waitsound = plus.createSound("Sounds\\button_click.wav", True, 0,0,0)
        # self.liftsound = plus.createSound("Sounds\\hzd_pusher_fire.wav", True, 0,0,0)
           
        self.AddHazard(self.lift1)

        self.RegisterZone("up", 1)
	self.RegisterZone("down", 2)
        self.RegisterZone("cup", 3)
	self.RegisterZone("cdown", 4)
	self.RegisterZone("stop", 5)
	


        self.AddCollisionLine((14.3, 18), (4, 7))
        self.AddCollisionLine((4, 7), (0, 8))
        self.AddCollisionLine((18, 14.3), (7, 4))
        self.AddCollisionLine((7, 4), (8, 0))

        self.AddCollisionLine((18, 14.3), (22, 12.5))
        self.AddCollisionLine((22, 12.5), (22, -12.5))
        self.AddCollisionLine((22, -12.5), (18, -14.3))

        self.AddCollisionLine((14.3, -18), (4, -7))
        self.AddCollisionLine((4, -7), (0, -8))
        self.AddCollisionLine((18, -14.3), (7, -4))
        self.AddCollisionLine((7, -4), (8, -0))

        self.AddCollisionLine((14.3, -18), (12.5, -22))
        self.AddCollisionLine((12.5, -22), (-12.5, -22))
        self.AddCollisionLine((-12.5, -22), (-14.3, -18))

        self.AddCollisionLine((-14.3, -18), (-4, -7))
        self.AddCollisionLine((-4, -7), (-0, -8))
        self.AddCollisionLine((-18, -14.3), (-7, -4))
        self.AddCollisionLine((-7, -4), (-8, -0))


        self.AddCollisionLine((-18, -14.3), (-22, -12.5))
        self.AddCollisionLine((-22, -12.5), (-22, 12.5))
        self.AddCollisionLine((-22, 12.5), (-18, 14.3))

        self.AddCollisionLine((-14.3, 18), (-4, 7))
        self.AddCollisionLine((-4, 7), (-0, 8))
        self.AddCollisionLine((-18, 14.3), (-7, 4))
        self.AddCollisionLine((-7, 4), (-8, 0))

        self.AddCollisionLine((-14.3, 18), (-12.5, 22))
        self.AddCollisionLine((-12.5, 22), (12.5, 22))
        self.AddCollisionLine((12.5, 22), (14.3, 18))

        self.AddCollisionLine((12.5, 28.5), (9, 28.5))
        self.AddCollisionLine((9, 28.5), (16.6, 38.8))
        self.AddCollisionLine((16.6, 38.8), (29.3, 41))
        self.AddCollisionLine((29.3, 41), (40, 33.6))
        self.AddCollisionLine((40, 33.6), (40, 20.4))
        self.AddCollisionLine((40, 20.4), (28.5, 9))
        self.AddCollisionLine((28.5, 9), (28.5, 12.5))

        self.AddCollisionLine((-12.5, 28.5), (-9, 28.5))
        self.AddCollisionLine((-9, 28.5), (-16.6, 38.8))
        self.AddCollisionLine((-16.6, 38.8), (-29.3, 41))
        self.AddCollisionLine((-29.3, 41), (-40, 33.6))
        self.AddCollisionLine((-40, 33.6), (-40, 20.4))
        self.AddCollisionLine((-40, 20.4), (-28.5, 9))
        self.AddCollisionLine((-28.5, 9), (-28.5, 12.5))

        self.AddCollisionLine((12.5, -28.5), (9, -28.5))
        self.AddCollisionLine((9, -28.5), (16.6, -38.8))
        self.AddCollisionLine((16.6, -38.8), (29.3, -41))
        self.AddCollisionLine((29.3, -41), (40, -33.6))
        self.AddCollisionLine((40, -33.6), (40, -20.4))
        self.AddCollisionLine((40, -20.4), (28.5, -9))
        self.AddCollisionLine((28.5, -9), (28.5, -12.5))

        self.AddCollisionLine((-12.5, -28.5), (-9, -28.5))
        self.AddCollisionLine((-9, -28.5), (-16.6, -38.8))
        self.AddCollisionLine((-16.6, -38.8), (-29.3, -41))
        self.AddCollisionLine((-29.3, -41), (-40, -33.6))
        self.AddCollisionLine((-40, -33.6), (-40, -20.4))
        self.AddCollisionLine((-40, -20.4), (-28.5, -9))
        self.AddCollisionLine((-28.5, -9), (-28.5, -12.5))

	self.AddCollisionLine((14.3, 18), (18, 14.3))
	self.AddCollisionLine((-14.3, 18), (-18, 14.3))
	self.AddCollisionLine((14.3, -18), (18, -14.3))
	self.AddCollisionLine((-14.3, -18), (-18, -14.3))


        self.AddPOV(0, (-25, 25), (1, 7))
        self.AddPOV(1, (0, 25), (2, 0))
        self.AddPOV(2, (25, 25), (3, 1))
        self.AddPOV(3, (25, 0), (4, 2))
        self.AddPOV(4, (25, -25), (5, 3))
        self.AddPOV(5, (0, -25), (6, 4))
        self.AddPOV(6, (-25, -25), (7, 5))
        self.AddPOV(7, (0, -25), (0, 6))


	return Arenas.SuperArena.HazardsOn(self, on)

    def Activate(self, on):
        if on: self.players = plus.getPlayers()
        
        Arenas.SuperArena.Activate(self, on)


    def ZoneEvent(self, direction, id, robot, chassis):
	if id == 1 and self.lstatus ==0 and direction ==1 and (robot==1 or robot==2 or robot==3 or robot==4):
	    self.lift1.MoveUp(1, robot-1)
	    self.lstatus = 1
	    self.ltimer = 0
	    self.called = 1
	if id == 2 and self.lstatus ==0 and direction ==1 and (robot==1 or robot==2 or robot==3 or robot==4):
	    self.lstatus = 1
	    self.ltimer = 15
	    self.called = 0
	    self.lift1.MoveDown(-1, robot-1)
	if id == 3 and self.called == 0 and self.lstatus ==0 and direction ==1 and (robot==1 or robot==2 or robot==3 or robot==4):
	    self.lstatus = 1
	    self.ltimer = -6
	    self.called = 1
	    self.lift1.CallUp(1)
	if id == 4 and self.lstatus ==0 and direction ==1 and (robot==1 or robot==2 or robot==3 or robot==4):
	    self.lstatus = 1
	    self.ltimer = 15
	    self.called = 0
	    self.lift1.CallDown(-1)
	if id == 5 and self.lstatus ==1 and self.called == 1 and direction ==-1 and (robot==1 or robot==2 or robot==3 or robot==4):
	    self.lstatus = 0
	    self.ltimer = 0
	    self.lift1.StopLift()


	return True


    def Tick(self):
	if self.lstatus == 1:
	    self.ltimer +=0.5
	    if self.ltimer == 0 and self.called == 1:
		self.lift1.StopLift()
	    if self.ltimer == 20:
		self.lstatus =0
		self.lift1.Bing()

        # check to see if anyone has been "eliminated" by falling off the tabletop
        for each in self.players:
            if plus.getLocation(each)[1] < -200:
                plus.eliminatePlayer(each)

        return Arenas.SuperArena.Tick(self)
        
Arenas.register(BoxArena)
